import os
from datetime import date, datetime

from django.conf import settings
from django.core.files.storage import FileSystemStorage

import uuid

FILES_PREFIX_PATH = f"{settings.MEDIA_ROOT}/files"
IMAGES_PREFIX_PATH = f"{settings.MEDIA_ROOT}/images"

# Funcion que devolvera el nombre de un archivo
def getFileName(file) -> str:
    # Obtiene la fecha y tiempo actual para concatenarlo a el nombre del archivo
    now_date = datetime.now().timestamp()
    # Obtiene el nombre y la extension del archivo
    split_tup = os.path.splitext(file.name)
    file_extension = split_tup[1]
    file_name = split_tup[0]
    # Nombre final del archivo
    nombre_archivo = file_name + f"-{now_date}" + file_extension
    return nombre_archivo

# Funcion que retornara el nombre de un archivo con su extension
def getFileNameWithExtension(file):
    split_tup = os.path.splitext(file.name)
    file_extension = split_tup[1]
    file_name = split_tup[0]
    return f"{file_name}{file_extension}"


# Funcion que devolvera la extension de un archivo
def getFileExtension(file) -> str:
    split_tup = os.path.splitext(file.name)
    return split_tup[1]


# Funcion que subira un archivo especifico al servidor y retornara la ruta en donde se encuentra
def upload_file_to_server(folder_name,file_name,file,original_name=False):
    fs = FileSystemStorage(location=f"{FILES_PREFIX_PATH}/{folder_name}/")
    # Obtiene la fecha y tiempo actual para concatenarlo a el nombre del archivo
    now_date = str(datetime.now().timestamp())
    # Genera UUID aleatorio
    uuid_u = str(uuid.uuid4())[0:13]
    if not original_name: # Si no quiere el nombre original, forma el nombre final del archivo concatenadole el timestamp y el nombre pasado por parametro
        # Obtiene el nombre y la extension del archivo
        split_tup = os.path.splitext(file.name)
        file_extension = split_tup[1]
        # Nombre final del archivo
        nombre_archivo = f"{file_name}" + f"-{uuid_u}" + file_extension
    if original_name: # Entra a esta condicion si quiere mantener el nombre de archivo original (agregando un timestamp para evitar duplicados)
        #nombre_archivo = f"{now_date[-5:]}-{file.name}"
        file_name_tokens = os.path.splitext(file.name)
        file_name_temp = file_name_tokens[0]
        file_extension_temp = ""
        try:
            file_extension_temp = file_name_tokens[1]
        except:
            pass

        # Verifica si el nombre del archivo tiene un uuid ya incluido de ser asi, remplazara ese uuid
        uuid_name_tokens = str(file.name).split("_uui_")

        if "_uui_" in file.name:
            # Remplaza el UUID
            uuid_u = str(uuid.uuid4())[0:13]
            nombre_archivo = f"{uuid_name_tokens[0]}_uui_{uuid_u}{file_extension_temp}"
        else:
            nombre_archivo = f"{file_name_temp}_uui_{uuid_u}{file_extension_temp}"

    fs.save(nombre_archivo,file)
    ruta = f"media/files/{folder_name}/{nombre_archivo}"
    return ruta

# Funcion que subira una imagen especifica al servidor y retornara la ruta en donde se encuentra
def upload_image_to_server(folder_name,image_name,image_file,original_name=False):
    fs = FileSystemStorage(location=f"{IMAGES_PREFIX_PATH}/{folder_name}/")
    # Obtiene la fecha y tiempo actual para concatenarlo a el nombre del archivo
    now_date = str(datetime.now().timestamp())
    # Genera UUID aleatorio
    uuid_u = str(uuid.uuid4())[0:13]
    if not original_name:
        # Obtiene el nombre y la extension del archivo
        split_tup = os.path.splitext(image_file.name)
        file_extension = split_tup[1]
        # Nombre final del archivo
        nombre_archivo = f"{image_name}" + f"-{uuid_u}" + file_extension
    if original_name: # Entra a esta condicion si quiere mantener el nombre de archivo original (agregando un timestamp para evitar duplicados)
        #nombre_archivo = f"{now_date[-5:]}-{file.name}"
        file_name_tokens = os.path.splitext(image_file.name)
        file_name_temp = file_name_tokens[0]
        file_extension_temp = ""
        try:
            file_extension_temp = file_name_tokens[1]
        except:
            pass

        # Verifica si el nombre del archivo tiene un uuid ya incluido de ser asi, remplazara ese uuid
        uuid_name_tokens = str(file.name).split("_uui_")

        if "_uui_" in file.name:
            # Remplaza el UUID
            uuid_u = str(uuid.uuid4())[0:13]
            nombre_archivo = f"{uuid_name_tokens[0]}_uui_{uuid_u}{file_extension_temp}"
        else:
            nombre_archivo = f"{file_name_temp}_uui_{uuid_u}{file_extension_temp}"

    fs.save(nombre_archivo,image_file)
    ruta = f"media/images/{folder_name}/{nombre_archivo}"
    return ruta
