# Importamos la libreria smtplib para enviar e-mails con SMTP
import smtplib, ssl
# Importamos los modulos de email
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from email.mime.image import MIMEImage
from email.utils import formataddr
from django.conf import settings

import os
import random

# datetime
from datetime import datetime, date

# Archivo: email_utils.py
# Fecha de modificación: 2023/10/03 19:32:27
# Autor: InterWebGdl
# Version: 1.0
# Sitio web: https://interwebgdl.com
# Contacto: sgcarlos@interwebgdl.com

# Clase que se encargara de enviar e-mails comunes mediante SMTP
class Email:
    port = 465
    smtp_server = "mail.grudicomerp.com"
    sender_email = "noreply@grudicomerp.com"
    password = "zAOQb&}y#9xu"

    # Funcion que enviara un correo de verificación con un código a un destinatario al querer restablecer una contraseña
    # de un usuario
    @classmethod
    def send_reset_password_code(cls, destinatario, codigo):
        # Creamos un mensaje de tipo 'MIMEMultipart'
        message = MIMEMultipart()
        # Declaramos el header del e-mail a enviar
        message["Subject"] = "Restablecimiento de contraseña"
        message["From"] = formataddr(('Grudicom ERP', cls.sender_email))
        message["To"] = destinatario

        # Crea la version HTML y texto plano de nuestro mensaje
        text = f"""\
                Hola,

                Se ha recibido una solicitud para restablecer tu contraseña de Grudicom Admin.
                Para restablecer la contraseña, ingresa el siguiente código de verificación de 6 digitos:
                            {codigo}

                            Tu email es: {destinatario}

                Si no solicitó un restablecimiento de contraseña, puede ignorar este correo electrónico de manera segura.

                Gracias,

                El equipo de Grudicom ERP.
                            """

        html = f"""\

                <img style="display: block; margin: 0 auto; width: auto; height: auto; max-height: 120px"  src="https://grudicomerp.com/static/images/logo-grudicom-corp.png">
                <h1 style="text-align: center"><b>Restablecer Contraseña</b></h1>
                <br>
                <div style="background: #F6F8FC; display: block; margin: 0 auto; border-radius: 30px; height: auto; padding: 25px">
                <p style="font-size: 1.5em; text-align: center; color: #000000"><b>Hola, se ha recibido una solicitud para restablecer la contraseña de tu cuenta de Grudicom ERP.</b></p>
                <p style="text-align: center">Para restablecer la contraseña, escriba el siguiente código de verificación en la app móvil o en el sistema web: </p>
                <br>

                <div style="width: 100%; text-align: center">
                <div style="background-color: #FFFFFF; border-radius: 27px; padding-left: 15px; padding-right: 15px; padding-top: 8px; padding-bottom: 8px; display: inline-block;">
                            <p style="font-size: 1.2em; text-align: center; color: #000000; letter-spacing: 1px"><b>{codigo}</b></p>
                </div>
                </div>

                <br>
                            <p style="text-align: center">Tu email es: <b>{destinatario}</b></p>
                <br>
                <p style="text-align: center; color: #727C8F">Si no solicitó un restablecimiento de contraseña, puede ignorar este correo electrónico de manera segura.</p>
                </div>
                <br>
                <br>
                <label style="color: #727C8F; text-align: center; display: block; margin: 0 auto">grudicomerp.com © {datetime.today().year}</label>
        """

        # Los coloca en objetos MIMEText
        part1 = MIMEText(text, "plain")
        part2 = MIMEText(html, "html")

        # Añade las partes texto plano/html a el objeto MIMEMultipart mensaje
        # El cliente de email tratara de renderizar primero la ultima parte 'html'
        message.attach(part1)
        message.attach(part2)

        # MIME que guadara la imagen insertada en el cuerpo del mensaje
        """"
        msgImage = None

        # Aqui incuira en el mensaje el logo de la empresa como parte del cuerpo del mensaje
        with open(f"{settings.STATIC_ROOT}/images/logo-grudicom.png", "rb") as img:
            msgImage = MIMEImage(img.read())

        # Define el id de la imagen en el html como referencia para insertar la imagen
        msgImage.add_header('Content-ID', '<logo>')
        message.attach(msgImage)
        """

        # Crea una conexión segura con el servidor y envia el e-mail
        context = ssl.create_default_context()
        with smtplib.SMTP_SSL(cls.smtp_server, cls.port, context=context) as server:
            server.login(cls.sender_email, cls.password)
            server.sendmail(
                cls.sender_email, destinatario, message.as_string()
            )

            print(f"El correo se envio exitosamente a el correo -> {destinatario}")

            return True



if __name__ == "__main__":
    # Codigo de verificacion aleatorio
    codigo = random.randint(100000, 999999)
    Email.send_reset_pass("sm.carlosadrian@gmail.com", codigo)
