from django.db import models
from oficinas.models import Oficinas
from clientes.models import Clientes

class EstatusProyectoGardclean(models.Model):
    estatus_proyecto_gardclean_id = models.AutoField(primary_key=True)
    nombre = models.CharField(max_length=100)

    class Meta:
        db_table = "estatus_proyecto_gardclean"

class ProyectoGardclean(models.Model):
    proyecto_gardclean_id = models.AutoField(primary_key=True)
    titulo = models.CharField(max_length=100)
    encabezado = models.CharField(max_length=500)
    primer_firma = models.CharField(max_length=300)
    segunda_firma = models.CharField(max_length=300)

    oficina = models.ForeignKey(to=Oficinas,on_delete=models.DO_NOTHING)
    cliente = models.ForeignKey(to=Clientes,on_delete=models.DO_NOTHING)
    estatus_proyecto_gardclean = models.ForeignKey(to=EstatusProyectoGardclean,on_delete=models.DO_NOTHING)
    created_at = models.DateTimeField(auto_now_add=True)

    class Meta:
        db_table = "proyectos_gardclean"


# Secciones predefinidas para cada PROYECTO GARDCLEAN
class SeccionProyectoGc(models.Model):
    seccion_proyecto_gc_id = models.AutoField(primary_key=True)
    titulo = models.CharField(max_length=300)
    num_img_evidencia = models.IntegerField(default=None)
    proyecto_gardclean = models.ForeignKey(to=ProyectoGardclean,on_delete=models.DO_NOTHING)
    created_at = models.DateTimeField(auto_now_add=True)

    class Meta:
        db_table = "secciones_proyecto_gc"

class ZonaReporteGc(models.Model):
    zona_reporte_gc_id = models.AutoField(primary_key=True)
    nombre = models.CharField(max_length=100)

    class Meta:
        db_table = "zonas_reporte_gc"

class ClienteZonaReporteGc(models.Model):
    cliente_zona_reporte_gc_id = models.AutoField(primary_key=True)
    cliente = models.ForeignKey(to=Clientes,on_delete=models.DO_NOTHING)
    zona_reporte_gc = models.ForeignKey(to=ZonaReporteGc,on_delete=models.DO_NOTHING)

    class Meta:
        db_table = "clientes_zonas_reporte_gc"

class DatosGeneralesReporteG(models.Model):
    datos_generales_reporte_g_id = models.AutoField(primary_key=True)
    tipo_zona = models.ForeignKey(to=ZonaReporteGc,on_delete=models.DO_NOTHING)
    zona = models.CharField(max_length=150, db_collation='utf8mb4_general_ci')
    limites = models.CharField(max_length=150, db_collation='utf8mb4_general_ci')
    desecho = models.CharField(max_length=50, db_collation='utf8mb4_general_ci')
    desecho_unidad = models.CharField(max_length=30,db_collation="utf8mb4_general_ci")
    superficie = models.CharField(max_length=70, db_collation='utf8mb4_general_ci')
    superficie_unidad = models.CharField(max_length=30, db_collation="utf8mb4_general_ci")


    class Meta:
        db_table = 'datos_generales_reporte_g'

class EstatusReporteGardclean(models.Model):
    estatus_reporte_gardclean_id = models.AutoField(primary_key=True)
    nombre = models.CharField(max_length=100)

    class Meta:
        db_table = "estatus_reporte_gardclean"

class ReporteGardclean(models.Model):
    reporte_gardclean_id = models.AutoField(primary_key=True)
    titulo = models.CharField(max_length=300)
    #tipo_zona_reporte_gc = models.ForeignKey(to=ZonaReporteGc,on_delete=models.DO_NOTHING)
    num_adquisicion = models.CharField(max_length=50)
    requirente = models.CharField(max_length=300)
    fecha_intervencion = models.DateTimeField()
    num_vuelta = models.IntegerField()
    proyecto_gardclean = models.ForeignKey(to=ProyectoGardclean,on_delete=models.DO_NOTHING)
    datos_generales = models.ForeignKey(DatosGeneralesReporteG, models.DO_NOTHING, blank=True, null=True)
    ruta_reporte_generado = models.CharField(max_length=300)
    estatus_reporte_gardclean = models.ForeignKey(to=EstatusReporteGardclean,on_delete=models.DO_NOTHING)
    created_at = models.DateTimeField(auto_now_add=True)

    class Meta:
        db_table = 'reportes_gardclean'


# Secciones para cada REPORTE GARDCLEAN EN ESPECIFICO
class SeccionReporteGardclean(models.Model):
    seccion_reporte_gardclean_id = models.AutoField(primary_key=True)
    #titulo = models.CharField(max_length=200)
    reporte_gardclean = models.ForeignKey(to=ReporteGardclean,on_delete=models.DO_NOTHING)
    seccion_proyecto_gc = models.ForeignKey(to=SeccionProyectoGc,on_delete=models.DO_NOTHING)

    class Meta:
        db_table = "secciones_reporte_gardclean"

class ImagenEvidenciaRg(models.Model):
    imagen_evidencia_rg_id = models.AutoField(primary_key=True)
    ruta = models.CharField(max_length=1000)
    descripcion = models.CharField(max_length=60)
    seccion_reporte_gardclean = models.ForeignKey(to=SeccionReporteGardclean,on_delete=models.DO_NOTHING)

    class Meta:
        db_table = "imagenes_evidencias_rg"



