from django.db import models
from oficinas.models import Oficinas

# Modelos para la aplicación 'Puestos'

class Puestos(models.Model):
    puesto_id = models.AutoField(db_column='Puesto_Id', primary_key=True)  # Field name made lowercase.
    puesto_nombre = models.CharField(db_column='Puesto_Nombre', max_length=200, blank=True, null=True)  # Field name made lowercase.
    class Meta:
        db_table = 'puestos'

class OficinaPuestoCol(models.Model):
    oficina_puesto_col_id = models.AutoField(primary_key=True)
    oficina = models.ForeignKey(to=Oficinas,on_delete=models.SET_NULL, null=True)
    puesto = models.ForeignKey(to=Puestos,on_delete=models.SET_NULL, null=True)

    class Meta:
        db_table = 'oficinas_puestos_col'
        