from django.db import models
# Archivo: models.py
# Fecha de modificación: 2025/10/12 19:51:47
# Autor: InterWebGdl
# Version: 1.0
# Sitio web: https://interwebgdl.com
# Contacto: sgcarlos@interwebgdl.com

# *** Modelos para la aplicación 'Oficinas' ***
class Oficinas(models.Model):
    oficina_id = models.AutoField(db_column='Oficina_Id', primary_key=True)  # Field name made lowercase.
    oficina_nombre = models.CharField(db_column='Oficina_Nombre', max_length=100, db_collation='utf8mb3_general_ci')  # Field name made lowercase.
    oficina_foto = models.CharField(db_column='Oficina_Foto', max_length=100, db_collation='utf8mb3_general_ci')  # Field name made lowercase.
    oficina_registro_federal = models.CharField(db_column="Oficina_Registro_Federal",max_length=145)
    oficina_permiso = models.CharField(db_column="Oficina_Permiso",max_length=145)
    #oficina_domicilio = models.CharField(db_column="Oficina_Domicilio",max_length=245)
    oficina_municipio_ciudad = models.CharField(db_column="Oficina_Municipio_Ciudad",max_length=245)
    oficina_entidad_federativa = models.CharField(db_column="Oficina_Entidad_Federativa",max_length=245)
    oficina_codigo_postal = models.CharField(db_column="Oficina_Codigo_Postal",max_length=15)
    oficina_calle_numero = models.CharField(db_column="Oficina_Calle_Numero",max_length=300)
    oficina_colonia = models.CharField(db_column="Oficina_Colonia",max_length=100)

    oficina_fecha_registro = models.DateTimeField(auto_now_add=True)
    oficina_fecha_modificacion = models.DateField(auto_now=True)


    class Meta:
        db_table = 'oficinas'

class OficinasGestores(models.Model):
    ofi_ges_id = models.AutoField(db_column="Ofi_Ges_Id",primary_key=True)
    ofi_ges_oficina = models.ForeignKey(Oficinas,models.CASCADE,db_column="Ofi_Ges_Oficina")
    ofi_ges_gestor = models.ForeignKey("usuarios.Usuario",models.CASCADE,db_column="Ofi_Ges_Gestor")

    class Meta:
        db_table = 'oficinas_gestores'

