# account_utils.py

from django.db.models import Q

# Modelos
from clientes.models import CuentaCliente
from usuarios.models import Usuario

# Account types
from utils.account_types import AccountType


# Roles de usuario
from utils.user_roles import RH_RANGO, ADMIN_RANGO, CABINA_RANGO, CONTRALOR_RANGO, COORDINADOR_RANGO, COMPRAS_RANGO, SUPERVISOR_RANGO

# Metodo que verifica si una cuenta existe en la base de datos
def verify_email_account_exists(email):
    # Verifica si existe una cuenta de ERP con el correo
    usuario_erp_email_query = Q(correo=email)
    usuario_erp_rol_query = Q(rango_permiso=ADMIN_RANGO)
    usuario_erp_rol_query.add(Q(rango_permiso=SUPERVISOR_RANGO), Q.OR)
    usuario_erp_rol_query.add(Q(rango_permiso=COORDINADOR_RANGO), Q.OR)

    usuario_erp = Usuario.objects.filter(usuario_erp_email_query & usuario_erp_rol_query).first()

    # Verifica si existe una cuenta de cliente con el correo
    cuenta_cliente = CuentaCliente.objects.filter(correo=email).first()

    return usuario_erp is not None or cuenta_cliente is not None

# Metodo que verifica que tipo de cuenta le pertenece a un email
def which_account_type(email):
    usuario_erp_email_query = Q(correo=email)
    usuario_erp_rol_query = Q(rango_permiso=ADMIN_RANGO)
    usuario_erp_rol_query.add(Q(rango_permiso=SUPERVISOR_RANGO), Q.OR)
    usuario_erp_rol_query.add(Q(rango_permiso=COORDINADOR_RANGO), Q.OR)

    usuario_erp = Usuario.objects.filter(usuario_erp_email_query & usuario_erp_rol_query).first()

    # Verifica si existe una cuenta de cliente con el correo
    cuenta_cliente = CuentaCliente.objects.filter(correo=email).first()

    #return AccountType.ERP if usuario_erp is not None else AccountType.CLIENTE
    return usuario_erp if usuario_erp is not None else cuenta_cliente