from django.http import JsonResponse
from django.shortcuts import render, HttpResponse
import urllib.parse
from http import HTTPStatus
import requests

STATIC_MAPS_URL = "https://maps.googleapis.com/maps/api/staticmap?"
#STATIC_MAPS_URL = "https://api.mapbox.com/styles/v1/mapbox/streets-v12/static/"

GEOCODING_MAPS_URL = "https://maps.googleapis.com/maps/api/geocode/json?"

MAPBOX_API_KEY = "pk.eyJ1Ijoicm9iZXJ0by1jYXJ6NyIsImEiOiJjbWg0OXU2aWQwZnY5MnFxNTJ0YTFuMmc2In0.byYmD9TiMV8zLdYdtFf00w"
GOOGLE_MAPS_API_KEY="AIzaSyA7auPR-bjIERNqTETb0eN-DZHi_7G9H_0"

# Vista que retornara un mapa estatico con la latitud y longitud pasada
def get_static_map_by_latlng(request):
    if request.method == "GET":
        # Obtiene latitud y longitud
        latitude = request.GET.get("latitude")
        longitude = request.GET.get("longitude")
        #,0,60
        """"
        final_url = STATIC_MAPS_URL
        final_url += f"{longitude},{latitude},18.25/"
        final_url += "1000x740?"
        final_url += f"access_token={MAPBOX_API_KEY}"
        """
        final_url = STATIC_MAPS_URL
        final_url += f"center={latitude},{longitude}&"
        final_url += f"zoom=17&"
        final_url += f"size=500x320&"
        final_url += f"scale=2&"
        final_url += f"markers=color:0x0069D9%7Clabel:%7C{latitude},{longitude}&"
        final_url += f"key={GOOGLE_MAPS_API_KEY}"



        # urllib.parse.quote(final_url, safe="~()*!.'")
        response = {
            "url": final_url
        }

        return JsonResponse(response)

    return HttpResponse(HTTPStatus.METHOD_NOT_ALLOWED)

def get_static_map_by_address_local(address,size="2480x1240",zoom="14",scale="2",styles=[]):
    final_url = STATIC_MAPS_URL
    final_url += f"center={address}&"
    final_url += f"size={size}&"
    final_url += f"zoom={zoom}&"
    final_url += f"scale={scale}&"

    for style in styles:
        final_url += f"{style}&"
    #final_url += f"{style}&"

    final_url += f"key={GOOGLE_MAPS_API_KEY}"

    return final_url

def get_address_by_latlng(request):
    if request.method == "GET":
        # Obtiene latitud y longitud
        latitude = request.GET.get("latitude")
        longitude = request.GET.get("longitude")

        #final_url = GEOCODING_MAPS_URL
        #final_url += f"latlng={latitude},{longitude}"
        #final_url += f"key={MAPS_API_KEY}"

        # Realiza la peticion y obtiene el resultado en json
        resultado = requests.get(GEOCODING_MAPS_URL, {
            f"latlng": f"{latitude},{longitude}",
            f"key": f"{GOOGLE_MAPS_API_KEY}"
        }).json()

        # Retorna la respuesta
        response = {
            "address": resultado["results"][0]["formatted_address"]
        }

        return JsonResponse(response)


    return HttpResponse(HTTPStatus.METHOD_NOT_ALLOWED)